using System;
using System.Collections.Generic;
using System.Text;

public class Program
{

    static HashSet<long> Solve(long n)
    {
        if (n <= 10000)
        {
            var set = new HashSet<long>();
            for (long i = 1; i <= n; i++)
            {
                long x = i, prod = 1;
                while (x > 0)
                {
                    prod *= x % 10;
                    x /= 10;
                }
                set.Add(prod);
            }
            return set;
        }
        var cifre = new List<int>();
        long temp = n;
        while (temp > 0)
        {
            cifre.Add((int)(temp % 10));
            temp /= 10;
        }
        cifre.Reverse();
        var recnik = new Dictionary<(int, bool, bool, long), HashSet<long>>();
        HashSet<long> DP(int pos, bool sada, bool poceli, long prod)
        {
            var key = (pos, sada, poceli, prod);
            if (recnik.ContainsKey(key)) return recnik[key];
            if (pos == cifre.Count)
            {
                if (!poceli) return new HashSet<long>();
                return new HashSet<long> { prod };
            }
            var res = new HashSet<long>();
            int max;
            if (sada)
            {
                max = cifre[pos];
            }
            else
            {
                max = 9;
            }

            for (int d = 0; d <= max; d++)
            {
                bool sledeci = sada && (d == max);
                bool pocelisledecu = poceli || d != 0;
                long nextProd = pocelisledecu ? prod * d : prod;
                if (!pocelisledecu) nextProd = 1;
                res.UnionWith(DP(pos + 1, sledeci, pocelisledecu, nextProd));
            }
            recnik[key] = res;
            return res;
        }
        return DP(0, true, false, 1);
    }

    public static void Main(string[] args)
    {
        int T = int.Parse(Console.ReadLine());
        for (int t = 0; t < T; t++)
        {
            long n = long.Parse(Console.ReadLine());
            var products = Solve(n);
            Console.WriteLine(products.Count);
        }
    }
}